<?php
namespace boru\openai\models;

use boru\openai\api\endpoints\Files;
use boru\openai\OpenAI;
use boru\openai\tools\OCR;
use Exception;

class File extends Base {
    private static $tableName;
    /** @var string */
    private $id;
    /** @var string */
    private $object = "file";
    /** @var int */
    private $createdAt;
    /** @var string|null */
    private $filename;
    /** @var int|null */
    private $bytes;
    /** @var string */
    private $md5;
    /** @var string */
    private $purpose;
    /** @var string */
    private $statusDetails;
    /** @var string|null */
    private $ocrContent;
    /** @var int */
    private $ocrTokens = 0;
    /** @var string|null */
    private $ocrDate;

    public static function tableName($tableName=null) {
        if($tableName) {
            static::$tableName = $tableName;
        }
        if(static::$tableName === null) {
            static::$tableName = OpenAI::table("files","boru_openai_files");
        }
        return static::$tableName;
    }
   
    public function id($id=null) {
        if ($id) {
            $this->id = $id;
        }
        return $this->id;
    }
    public function object($object=null) {
        if ($object) {
            $this->object = $object;
        }
        return $this->object;
    }
    public function createdAt($created=null) {
        if ($created) {
            $this->createdAt = $created;
        }
        return $this->createdAt;
    }
    public function filename($filename=null) {
        if ($filename) {
            $this->filename = $filename;
        }
        return $this->filename;
    }
    public function bytes($bytes=null) {
        if ($bytes) {
            $this->bytes = $bytes;
        }
        return $this->bytes;
    }
    public function md5($md5=null) {
        if ($md5) {
            $this->md5 = $md5;
        }
        return $this->md5;
    }
    public function purpose($purpose=null) {
        if ($purpose) {
            $this->purpose = $purpose;
        }
        return $this->purpose;
    }
    public function statusDetails($statusDetails=null) {
        if ($statusDetails) {
            $this->statusDetails = $statusDetails;
        }
        return $this->statusDetails;
    }
    public function ocrContent($ocrContent=null) {
        if ($ocrContent) {
            $this->ocrContent = $ocrContent;
        }
        return $this->ocrContent;
    }
    public function ocrTokens($ocrTokens=null) {
        if ($ocrTokens) {
            $this->ocrTokens = $ocrTokens;
        }
        return $this->ocrTokens;
    }
    public function ocrDate($ocrDate=null) {
        if ($ocrDate) {
            $this->ocrDate = $ocrDate;
        }
        return $this->ocrDate;
    }

    public function ocr($force=false,$detail="high",$assistant=null) {
        if($assistant) {
            $assistant = Assistant::fromInput($assistant);
        }
        if(!$assistant) {
            $assistant = Assistant::fromInput("ocr");
        }
        if(!$force && $this->ocrContent()) {
            if(!$this->ocrTokens()) {
                $tokens = $assistant->encode($this->ocrContent());
                $this->ocrTokens(count($tokens));
                $this->save();
            }
            return $this->ocrContent();
        }
        if($assistant) {
            $assistant = Assistant::fromInput($assistant);
        }
        if(!$assistant) {
            $assistant = Assistant::fromName("ocr");
        }
        $ocr = new OCR(["detail"=>$detail]);
        $ocr->fileId($this->id());
        $result = $ocr->run();
        if($result) {
            $this->ocrContent($result);
            $this->ocrDate(date("Y-m-d H:i:s"));
            if($this->content()) {
                $this->ocrTokens($ocr->tokenCount());
            }
            $this->save();
        }
    }

    public function delete() {
        $result = Files::delete($this->id());
        if($result) {
            $db = OpenAI::db();
            if($db) {
                $sql = "DELETE FROM ".static::tableName()." WHERE id=?";
                $db->query($sql,[$this->id()]);
            }
        }
        return $result;
    }
    public function content() {
        return Files::content($this->id());
    }

    public function save() {
        $db = OpenAI::db();
        if(!$db) {
            return false;
        }
        if(!$this->id()) {
            throw new Exception("File ID is required. Upload the file using static::upload() or set the ID using \$file->id(\$id)");
        }
        $sql = "INSERT INTO ".static::tableName()." (id,object,created_at,filename,purpose,bytes,status_details,md5,ocr_content,ocr_tokens,ocr_date) VALUES (?,?,?,?,?,?,?,?,?,?,?) ON DUPLICATE KEY UPDATE object=?,created_at=?,filename=?,purpose=?,bytes=?,status_details=?,md5=?,ocr_content=?,ocr_tokens=?,ocr_date=?";
        $db->query($sql,[
            $this->id(),$this->object(),$this->createdAt(),$this->filename(),$this->purpose(),$this->bytes(),$this->statusDetails(),$this->md5(),$this->ocrContent(),$this->ocrTokens(),$this->ocrDate(),
            $this->object(),$this->createdAt(),$this->filename(),$this->purpose(),$this->bytes(),$this->statusDetails(),$this->md5(),$this->ocrContent(),$this->ocrTokens(),$this->ocrDate()
        ]);
    }

    public function toArray() {
        return [
            "id" => $this->id(),
            "object" => $this->object(),
            "created_at" => $this->createdAt(),
            "filename" => $this->filename(),
            "purpose" => $this->purpose(),
            "bytes" => $this->bytes(),
            "status_details" => $this->statusDetails(),
            "md5" => $this->md5(),
            "ocr_content" => $this->ocrContent(),
            "ocr_tokens" => $this->ocrTokens(),
            "ocr_date" => $this->ocrDate()
        ];
    }

    public static function fromId($id) {
        $db = OpenAI::db();
        if($db) {
            $sql = "SELECT * FROM ".static::tableName()." WHERE id=?";
            $res = $db->run($sql,[$id]);
            while($row = $db->next($res)) {
                return new File($row->asArray());
            }
        }
        $result = Files::get($id);
        if(isset($result["id"])) {
            $result = new File($result);
            $result->save();
        } else {
            return false;
        }
        return $result;
    }

    public static function fromFile($fileNameOrStream,$purpose="") {
        return static::upload($fileNameOrStream,$purpose);
    }

    public static function upload($fileNameOrStream,$purpose="") {
        $parameters = [
            "purpose" => $purpose
        ];
        if(is_string($fileNameOrStream)) {
            if(!file_exists($fileNameOrStream)) {
                throw new Exception("File not found: ".$fileNameOrStream);
            }
            $parameters["file"] = fopen($fileNameOrStream,"r");
        } elseif(is_resource($fileNameOrStream)) {
            $parameters["file"] = $fileNameOrStream;
        } else {
            throw new Exception("Invalid file type");
        }
        $result = Files::upload($parameters);
        if(isset($result["id"])) {
            $file = new File($result);
            $file->save();
            return $file;
        }
        return $result;
    }

    public static function listNeedsOcr() {
        $db = OpenAI::db();
        if(!$db) {
            return [];
        }
        $sql = "SELECT * FROM ".static::tableName()." WHERE ocr_content IS NULL";
        $res = $db->run($sql);
        $files = [];
        while($row = $db->next($res)) {
            $files[] = new File($row->asArray());
        }
        return $files;
    }
}