<?php
namespace boru\openai\models;

use boru\openai\api\endpoints\Messages;

class Message extends Base {
    private $id;
    private $object = "thread.message";
    private $createdAt;
    private $threadId;
    private $role;

    /** @var Content */
    private $content;
    private $assistantId;
    private $runId;
    private $attachments;
    private $metadata;

    public function __construct($input=[]) {
        $this->content = new Content();
        if(!is_array($input)) {
            $this->role("user");
        } else {
            parent::__construct($input);
        }
    }

    public function id($id=null) {
        if ($id !== null) {
            $this->id = $id;
        }
        return $this->id;
    }
    public function object($object=null) {
        if ($object !== null) {
            $this->object = $object;
        }
        return $this->object;
    }
    public function createdAt($created=null) {
        if ($created !== null) {
            $this->createdAt = $created;
        }
        return $this->createdAt;
    }
    public function threadId($threadId=null) {
        if ($threadId !== null) {
            $this->threadId = $threadId;
        }
        return $this->threadId;
    }
    /**
     * Get or set the role of the message
     * @param mixed $role [user|assistant]
     * @return string|null 
     */
    public function role($role=null) {
        if ($role !== null) {
            $this->role = $role;
        }
        return $this->role;
    }

    /**
     * Get or set the content of the message
     * @param mixed $content
     * @return Content|null
     */
    public function content($content=null) {
        if ($content !== null) {
            if($content instanceof Content) {
                $this->content = $content;
            } else {
                $this->content = new Content($content);
            }
        }
        return $this->content;
    }
    public function assistantId($assistantId=null) {
        if ($assistantId !== null) {
            $this->assistantId = $assistantId;
        }
        return $this->assistantId;
    }
    public function runId($runId=null) {
        if ($runId !== null) {
            $this->runId = $runId;
        }
        return $this->runId;
    }
    public function attachments($attachments=null) {
        if ($attachments) {
            $this->attachments = $attachments;
        }
        return $this->attachments;
    }
    public function metadata($metadata=null) {
        if ($metadata) {
            $this->metadata = $metadata;
        }
        return $this->metadata;
    }

    public function save() {
        $data = [
            "thread_id"=>$this->threadId(),
            "rolw"=>$this->role(),
            "content"=>$this->content()->toArray(),
        ];
        if($this->attachments()) {
            $data["attachments"] = $this->attachments();
        }
        if($this->metadata()) {
            $data["metadata"] = $this->metadata();
        }
        $result = Messages::create($data);
        $this->id($result->id());
        $this->object($result->object());
        $this->createdAt($result->createdAt());
        $this->threadId($result->threadId());
        $this->role($result->role());
        $this->content($result->content());
        $this->assistantId($result->assistantId());
        $this->runId($result->runId());
        $this->attachments($result->attachments());
        $this->metadata($result->metadata());
        return $this;
    }

    public function forChat() {
        return [
            "role"=>$this->role(),
            "content"=>$this->content()->toArray(),
        ];
    }
    public function forThread() {
        $arr = ["role"=>$this->role(),"content"=>$this->content()->toArray()];
        if($this->attachments()) {
            $arr["attachments"] = $this->attachments();
        }
        return $arr;
    }

    public function toArray() {
        return [
            "id"=>$this->id(),
            "object"=>$this->object(),
            "created_at"=>$this->createdAt(),
            "thread_id"=>$this->threadId(),
            "role"=>$this->role(),
            "content"=>$this->content()->toArray(),
            "assistant_id"=>$this->assistantId(),
            "run_id"=>$this->runId(),
            "attachments"=>$this->attachments(),
            "metadata"=>$this->metadata()
        ];
    }

    public function text($text) {
        $this->content()->addText($text);
        return $this;
    }
    public function imageFile($fileId) {
        $this->content()->addImageFile($fileId);
        return $this;
    }
    public function audioFile($fileId) {
        $this->content()->addAudioFile($fileId);
        return $this;
    }

}