<?php
namespace boru\openai\tiktoken\util;

/** @psalm-type NonEmptyByteVector = non-empty-list<int<0, 255>> */
class EncodeUtil {
    /**
     * @param string $text Text must be valid UTF-8 string.
     *
     * @psalm-return NonEmptyByteVector
     */
    public static function toBytes(string $text): array
    {
        return array_map(function($x) { return hexdec($x); }, str_split(bin2hex($text), 2));
    }
}
