<?php

use boru\openai\embeddings\Document;
use boru\openai\embeddings\vectorstore\FileVectorStore;
use boru\output\Output;

require __DIR__.'/../init.php';

if(php_sapi_name() != "cli") {
    Output::outLine("This script is intended to be run from the command line");
    exit(1);
}
array_shift($argv);
$vectorStoreFile = __DIR__.'/store.json';
$path = __DIR__."/../../src";

if(!empty($argv)) {
    $path = array_shift($argv);
}

if(file_exists($vectorStoreFile)) {
    Output::outLine("Vector store already exists at $vectorStoreFile");
    exit(1);
}

$documents = [];
$files = getFileList($path);
Output::outLine("We have ".count($files)." files");
Output::outLine("Adding them to the vector store at $vectorStoreFile");
$vectorStore = new FileVectorStore($vectorStoreFile);
Output::outLine("Done");
$basePath = realpath($path);
if(substr($basePath,-1) != DIRECTORY_SEPARATOR) {
    $basePath .= DIRECTORY_SEPARATOR;
}
foreach($files as $file) {
    $extension = pathinfo($file, PATHINFO_EXTENSION);
    $mime = mime_content_type($file);
    $filename = pathinfo($file, PATHINFO_FILENAME);
    $filePath = str_replace($basePath,"",$file);
    $content = file_get_contents($file);
    $header = "The file path for this $mime file is $filePath\n";
    $doc = new Document();
    $doc->name($filePath);
    $doc->type($mime);
    $doc->content($header.$content);
    Output::outLine("Adding",$mime,"file",$filePath,"with extension",$extension);
    $vectorStore->addDocument($doc);
}

function getFileList($dir, &$results = array()) {
    $files = scandir($dir);

    foreach ($files as $key => $value) {
        $path = realpath($dir . DIRECTORY_SEPARATOR . $value);
        if (!is_dir($path)) {
            $results[] = $path;
        } else if ($value != "." && $value != "..") {
            getFileList($path, $results);
        }
    }

    return $results;
}