<?php
namespace boru\output;

class Output {
    protected static $instance;
    public $output;

    private $options = [
        "prefix"=>true,
        "prefixFormat"=>"date:Y-m-d H:i:s",
        "prefixSpacer"=>"\t",
        "trailingNewLine"=>true,
        "fileName"=>false,
        "fileAppend"=>true,
        "stdOut"=>true,
        "cursor"=>0,
        "indent"=>0,
        "lineSeparator"=>PHP_EOL,
        "lastTime"=>0
    ];

    private $lastTime = 0;
    private $cursor = 0;

    public function setOptions($options) {
        foreach($options as $key=>$value) {
            if(method_exists($this,$key)) {
                $this->{$key}($value);
            } else {
                $this->option($key,$value);
            }
            $this->option($key,$value);
        }
    }
    public function option($key,$value=null) {
        if(is_array($key)) {
            foreach($key as $k=>$v) {
                $this->option($k,$v);
            }
        } else {
            if(array_key_exists($key,$this->options)) {
                $this->{$key} = $value;
            }
        }
    }
    public function prefix($prefix=null) {
        if($prefix !== null) {
            $this->option("prefix",$prefix);
            return $this;
        }
        if($this->option("prefix")) {
            if($this->prefixFormat() == "execTime") {
                return "exec:{$this->execTime()}".$this->prefixSpacer();
            }
            $tt = explode(":",$this->prefixFormat(),2);
            if(count($tt)==2) {
                if($tt[0] == "date") {
                    return date($tt[1]).$this->prefixSpacer();
                }
            }
            return $this->prefixFormat().$this->prefixSpacer();
        }
        return "";
    }
    public function prefixFormat($prefixFormat=null) {
        if($prefixFormat !== null) {
            $this->option("prefixFormat",$prefixFormat);
            return $this;
        }
        return $this->option("prefixFormat");
    }
    public function prefixSpacer($prefixSpacer=null) {
        if($prefixSpacer !== null) {
            $this->option("prefixSpacer",$prefixSpacer);
            return $this;
        }
        return $this->option("prefixSpacer");
    }
    public function trailingNewLine($trailingNewLine=null) {
        if($trailingNewLine !== null) {
            $this->option("trailingNewLine",$trailingNewLine);
            return $this;
        }
        return $this->option("trailingNewLine");
    }
    public function fileName($fileName=null) {
        if($fileName !== null) {
            $this->option("fileName",$fileName);
            return $this;
        }
        return $this->option("fileName");
    }
    public function fileAppend($fileAppend=null) {
        if($fileAppend !== null) {
            $this->option("fileAppend",$fileAppend);
            return $this;
        }
        return $this->option("fileAppend");
    }
    public function stdOut($stdOut=null) {
        if($stdOut !== null) {
            $this->option("stdOut",$stdOut);
            return $this;
        }
        return $this->option("stdOut");
    }
    public function cursor($cursor=null) {
        if($cursor !== null) {
            $this->option("cursor",$cursor);
            return $this;
        }
        return $this->option("cursor");
    }
    public function indent($indent=null) {
        if($indent !== null) {
            $this->option("indent",$indent);
            return $this;
        }
        $indentValue = (int) $this->option("indent");
        if($indentValue>0) {
            return str_pad("",$indentValue," ");
        }
        return "";
    }
    public function lineSeparator($lineSeparator=null) {
        if($lineSeparator !== null) {
            $this->option("lineSeparator",$lineSeparator);
            return $this;
        }
        return $this->option("lineSeparator");
    }
    public function lastTime($lastTime=null) {
        if($lastTime !== null) {
            $this->lastTime = $lastTime;
            return $this;
        }
        return $this->lastTime;
    }
    private function eol() {
        return $this->lineSeparator();
    }

    
    protected $file;


    /**
     * Used to init the singleton with specific settings
     * @return dhOut singlton
     */
    public static function init($options=[]) {
        if(self::$instance !== null) {
            self::instance()->end();
        }
        self::$instance = new self($options);
        return self::$instance;
    }
    /**
     * Used to get the singleton isntance, or init with default settings;
     * @return dhOut singlton
     */
    public static function instance() {
        if(self::$instance === null) {
            self::$instance = self::init();
        }
        return self::$instance;
    }

    public function __construct($options=[]) {
        $this->setOptions($options);
        $this->output = [];
        $this->lastTime = -microtime(true);
    }
    public function __destruct() {
        if(!empty($this->output)) {
            $this->end();
        }
    }
    public function toOutput($content="") {
        $string = "";
        if(empty($content)) {
            $prevLine = $this->prevLine();
            if(!is_null($prevLine) && strlen($prevLine) == strlen(rtrim($this->prevLine(),$this->eol()))) {
                //$string.=$this->eol();
            }
            $string .= $this->currentLine();
        } else {
            $string = $content;
        }
        $string.=$this->eol();
        if($this->stdOut()) {
            $commands = "";
            StdOut::output($commands.$string);
        }
        if(!is_null($this->file) && $this->fileName() !== false) {
            $this->file->write($string,$this->fileAppend());
        }
    }
    public function clear() {
        $this->end();
    }

    
    public function line(...$args) {
        $parts = [];
        foreach($args as $arg) {
            $parts[] = $this->argToString($arg);
        }
        $line = $this->prefix();
        $line.= $this->indent();
        $line.= implode(" ",$parts);
        $this->output[] = $this->parseIndent($line);
        $this->cursor++;
        $this->toOutput();
        return $this;
    }
    public function a($data,$expectAppend=false) {
        return $this->line($data);
    }
    public function add($data,$expectAppend=false) {
        return $this->line($data);
    }
    private function parseIndent($line) {
        if($this->option("indent")>0) {
            $line = str_replace($this->eol(),$this->eol().$this->indent(),$line);
        }
        return $line;
    }
    private function argToString($arg) {
        if(is_array($arg) || is_object($arg)) {
            return print_r($arg,true);
        } else {
            return $arg;
        }
    }

    /**
     * Print content to the screen -- does not include a newline automatically.
     * @param Output $content 
     * @return void 
     */
    public function merge($otherOut) {
        //$otherOut must be either an instance of Output or a class that extends Output, or it must be an instance of \boru\dhutils\tools\Output
        if($otherOut instanceof Output) {
        } elseif(is_subclass_of($otherOut,"\\boru\\dhutils\\tools\\Output")) {
        } else {
            return;
        }
        if(!empty($this->output)) {
            $this->toOutput($this->eol());
        }
        $this->toOutput($otherOut->toString($this->eol(),false));
        $this->output = array_merge($this->output,$otherOut->output);
    }

    public function end() {
        $this->output = [];
        $this->cursor=0;
    }

    private function execTime() {
        $this->lastTime += microtime(true);
        $time = round($this->lastTime,4);
        $this->lastTime = -microtime(true);
        return $time;
    }
    public function toFile($filename,$flags=FILE_APPEND) {
        file_put_contents($filename,$this->toString(),$flags);
    }
    public function toString($lineSeparator=null,$trailing=true) {
        if(is_null($lineSeparator)) {
            $lineSeparator = $this->eol();
        }
        if($this->trailingNewLine() && $trailing) {
            $o = $lineSeparator;
        } else {
            $o = "";
        }
        return implode($lineSeparator,$this->output).$o;
    }
    public function __toString() {
        return $this->toString($this->eol());
    }

    public function prevLine() {
        if($this->cursor>1) {
            return $this->output[$this->cursor-2];
        }
        return null;
    }
    public function currentLine() {
        if($this->cursor>0) {
            return $this->output[$this->cursor-1];
        }
        return null;
    }

    /**
     * 
     * @param string|string[] $char a string or array of strings with 'start', 'clear', and/or 'up' as values
     * @return string|void 
     */
    public function ansiChar($char="start|clear|up") {
        if(!is_array($char)) {
            if($char == "start") {
                return "\r";
            }
            if($char == "clear") {
                return "\033[K";
            }
            if($char == "up") {
                return "\033[1A";
            }
        } else {
            $chars = [];
            foreach($char as $c) {
                $chars[] = $this->ansiChar($c);
            }
            return implode("",$chars);
        }
    }
}