<?php
namespace boru\output\table;

class Cell {
    private $text;
    private $row;
    private $index;
    private $span = 1;
    private $width = 0;
    private $align = "left";
    private $padding = 0;
    private $pad = " ";
    private $fill = " ";

    public static function properties() {
        return [
            "text"=>null,
            "row"=>null,
            "index"=>null,
            "span"=>1,
            "width"=>0,
            "align"=>"left",
            "padding"=>0,
            "pad"=>" ",
            "fill"=>" "
        ];
    }

    public function __construct($text,$options=[]) {
        $this->text = $text;
        $this->setData($options);
    }

    public function replace($search,$replace) {
        $this->text = str_replace($search,$replace,$this->text);
        return $this;
    }

    public function display() {
        $text = $this->text();
        $width = $this->width();
        $align = $this->align();
        $padding = $this->padding();
        $pad = $this->pad();
        $fill = $this->fill();
        if($width > 0) {
            $text = str_pad($text,$width);
        }
        if($padding > 0) {
            $text = str_repeat($pad,$padding).$text.str_repeat(" ",$padding);
        }
        if($align === "right") {
            $text = str_pad($text,$width,$fill,STR_PAD_LEFT);
        } elseif($align === "center") {
            $text = str_pad($text,$width,$fill,STR_PAD_BOTH);
        }
        return $text;
    }

    /**
     * Get the length of the text
     * @return int
     */
    public function length() {
        return strlen($this->text);
    }
    /**
     * Get or set the text
     * @param string|null $text
     * @return string|Cell
     */
    public function text($text=null) {
        if($text === null) {
            return $this->text;
        }
        $this->text = $text;
        return $this;
    }
    public function row($row=null) {
        if($row === null) {
            return $this->row;
        }
        $this->row = $row;
        return $this;
    }
    public function index($index=null) {
        if($index === null) {
            return $this->index;
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get or set the span of the cell
     * @param int|null $span
     * @return int|Cell
     */
    public function span($span=null) {
        if($span === null) {
            return $this->span;
        }
        $this->span = $span;
        return $this;
    }
    /**
     * Get or set the width of the cell
     * @param int|null $width
     * @return int|Cell
     */
    public function width($width=null) {
        if($width === null) {
            if($this->width === 0) {
                $this->width = $this->row()->getWidthFromTable($this->index());
            }
            return $this->width;
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get or set the alignment of the text
     * @param string|null $align
     * @return string|Cell
     */
    public function align($align=null) {
        if($align === null) {
            return $this->align;
        }
        $this->align = $align;
        return $this;
    }
    /**
     * Get or set the padding of the cell
     * @param int|null $padding
     * @return int|Cell
     */
    public function padding($padding=null) {
        if($padding === null) {
            return $this->padding;
        }
        $this->padding = $padding;
        return $this;
    }
    /**
     * Get or set the padding character
     * @param string|null $pad
     * @return string|Cell
     */
    public function pad($pad=null) {
        if($pad === null) {
            return $this->pad;
        }
        $this->pad = $pad;
        return $this;
    }
    /**
     * Get or set the fill character
     * @param string|null $fill
     * @return string|Cell
     */
    public function fill($fill=null) {
        if($fill === null) {
            return $this->fill;
        }
        $this->fill = $fill;
        return $this;
    }
    public function setData($data=[]) {
        if(!is_array($data) || empty($data)) {
            return;
        }
        foreach($data as $key=>$value) {
            if(method_exists($this,$key)) {
                $this->$key($value);
            }
        }
    }
    public function __toString() {
        return $this->text;
    }
}