<?php

namespace boru\process;

use boru\process\Loop\LoopProviderInterface;
use boru\process\Loop\PcntlLoopProvider;
use boru\process\Status\Sink\StatusSinkInterface;

/**
 * High-level API for running a pool of workers using a LoopProvider.
 */
class ProcessManager
{
    /**
     * @var LoopProviderInterface
     */
    protected $loopProvider;

    /**
     * @var int
     */
    protected $numWorkers = 1;

    /**
     * @param LoopProviderInterface|null $loopProvider
     * @param array                      $options
     */
    public function __construct(LoopProviderInterface $loopProvider = null, array $options = array())
    {
        $this->loopProvider = $loopProvider ?: new PcntlLoopProvider();

        if (isset($options['num_workers'])) {
            $this->numWorkers = (int)$options['num_workers'];
        }
    }

    /**
     * Run workers created by the given factory.
     *
     * @param callable $workerFactory Callable returning a WorkerInterface.
     * @return int Total number of items processed by all workers (best effort).
     */
    public function run(callable $workerFactory, StatusSinkInterface $sink = null)
    {
        return $this->loopProvider->runWorkers($workerFactory, $this->numWorkers, $sink);
    }

    /**
     * @return LoopProviderInterface
     */
    public function getLoopProvider()
    {
        return $this->loopProvider;
    }
}
