<?php

namespace boru\process\Queue\Bootstrap;

use boru\queue\Storage\QueueStorageInterface;
use boru\queue\Task\TaskRegistry;

/**
 * Builds per-worker environment inside the worker process:
 * queue storage, task registry, etc.
 */
interface WorkerEnvironmentBuilderInterface
{
    /**
     * Called inside each worker process to build its environment.
     *
     * @return array [QueueStorageInterface $storage, TaskRegistry $registry]
     */
    public function build();
}
