<?php

namespace boru\process\Status\Reporter;

/**
 * Simple status reporter that prints updates to STDOUT.
 *
 * Intended only for debugging / development, not for production TTY UX.
 */
class CliEchoStatusReporter implements StatusReporterInterface
{
    public function report(array $data)
    {
        // Very basic: one line per event
        $parts = array();

        if (isset($data['state'])) {
            $parts[] = 'state=' . $data['state'];
        }

        if (isset($data['processed'])) {
            $parts[] = 'processed=' . $data['processed'];
        }

        if (isset($data['queue'])) {
            $parts[] = 'queue=' . $data['queue'];
        }

        if (isset($data['item_id'])) {
            $parts[] = 'item_id=' . $data['item_id'];
        }

        if (isset($data['task_name'])) {
            $parts[] = 'task=' . $data['task_name'];
        }

        if (isset($data['error']) && is_array($data['error'])) {
            $parts[] = 'error=' . $data['error']['message'];
        }

        echo '[worker-status] ' . implode(' ', $parts) . PHP_EOL;
    }
}
