<?php

namespace boru\process\Status;

/**
 * Normalized status event sent from a worker to the manager.
 */
class WorkerStatusEvent
{
    public $pid;
    public $state;      // 'idle', 'busy', 'processed', 'error', 'stopped', etc.
    public $processed;  // int - number processed so far by this worker
    public $queue;      // string
    public $time;       // float (microtime)
    public $itemId;     // int|null
    public $taskName;   // string|null
    public $error;      // ['message' => ..., 'code' => ...] | null
    public $message;    // string|null - debug/info message

    public function __construct($pid, array $data)
    {
        $this->pid       = $pid;
        $this->state     = isset($data['state']) ? $data['state'] : null;
        $this->processed = isset($data['processed']) ? (int)$data['processed'] : 0;
        $this->queue     = isset($data['queue']) ? $data['queue'] : '';
        $this->time      = isset($data['time']) ? (float)$data['time'] : microtime(true);
        $this->itemId    = isset($data['item_id']) ? $data['item_id'] : null;
        $this->taskName  = isset($data['task_name']) ? $data['task_name'] : null;
        $this->error     = (isset($data['error']) && is_array($data['error'])) ? $data['error'] : null;
        $this->message   = isset($data['message']) ? $data['message'] : null;
    }
}
