<?php

namespace boru\process\Loop;

use boru\process\WorkerInterface;

/**
 * Abstraction over how workers are started and managed.
 *
 * Concrete implementations might use:
 * - plain pcntl_fork/pcntl_wait
 * - a ReactPHP-based supervisor
 * - or even in-process (no forking) for testing.
 */
interface LoopProviderInterface
{
    /**
     * Run multiple workers and return the total number of processed items.
     *
     * @param callable $workerFactory A callable that, when invoked with no
     *                                arguments, returns a WorkerInterface
     *                                instance for that worker process.
     * @param int      $numWorkers    Number of workers to start.
     *
     * @return int Total number of items processed by all workers.
     */
    public function runWorkers(callable $workerFactory, $numWorkers, \boru\process\Status\Sink\StatusSinkInterface $sink = null);
}
