<?php

namespace boru\process\Queue\Bootstrap;

use boru\dhdb\dhDB;
use boru\process\Queue\Bootstrap\WorkerEnvironmentBuilderInterface;
use boru\queue\Storage\MysqlQueueStorage;
use boru\queue\Storage\QueueStorageInterface;
use boru\queue\Task\TaskRegistry;
use boru\queue\Task\ClosureTask;

class MysqlWorkerEnvironmentBuilder implements WorkerEnvironmentBuilderInterface
{
    /**
     * @var array
     */
    protected $dbConfig;

    /**
     * @var string
     */
    protected $tableName;

    /**
     * @var callable|null
     */
    protected $taskRegistryFactory;

    /**
     * @param array         $dbConfig            dhDB connection config
     * @param string        $tableName          queue table name
     * @param callable|null $taskRegistryFactory function () : TaskRegistry
     */
    public function __construct(array $dbConfig, $tableName, $taskRegistryFactory = null)
    {
        $this->dbConfig            = $dbConfig;
        $this->tableName           = $tableName;
        $this->taskRegistryFactory = $taskRegistryFactory;
    }

    public function __destruct()
    {
        $this->taskRegistryFactory = null;   // Cleanup if needed
    }

    public function build()
    {
        $db = new dhDB($this->dbConfig,false);

        $storage = new MysqlQueueStorage($db, $this->tableName);

        if ($this->taskRegistryFactory && is_callable($this->taskRegistryFactory)) {
            $registry = call_user_func($this->taskRegistryFactory);
        } else {
            $registry = new TaskRegistry();
            // You can optionally register default tasks here,
            // or leave it to the factory callback.
        }

        return array($storage, $registry);
    }
}
