<?php

namespace boru\process\Status\Sink;

use boru\process\Status\WorkerStatusEvent;

/**
 * Consumer of worker status events on the manager side.
 */
interface StatusSinkInterface
{
    /**
     * Called for each status event decoded from a worker pipe.
     *
     * @param WorkerStatusEvent $event
     * @return void
     */
    public function handle(WorkerStatusEvent $event);

    /**
     * Called after all workers have finished, for final output/cleanup.
     *
     * @return void
     */
    public function finish();
}
