<?php

namespace boru\process\Queue;

use boru\queue\Storage\QueueStorageInterface;

class Enqueuer
{
    /**
     * @var QueueStorageInterface
     */
    protected $storage;

    /**
     * @var string
     */
    protected $queueName;

    /**
     * @var string
     */
    protected $taskName;

    /**
     * @var int
     */
    protected $enqueuedCount = 0;

    public function __construct(QueueStorageInterface $storage, $queueName, $taskName)
    {
        $this->storage   = $storage;
        $this->queueName = $queueName;
        $this->taskName  = $taskName;
    }

    /**
     * Enqueue a single payload for this runner's queue/task.
     *
     * @param mixed $payload
     * @return void
     */
    public function enqueue($payload)
    {
        $json = is_string($payload) ? $payload : json_encode($payload);
        $this->storage->enqueue($this->queueName, $this->taskName, $json);
        $this->enqueuedCount++;
    }

    /**
     * Enqueue many payloads at once.
     *
     * @param array $payloads
     * @return void
     */
    public function enqueueMany(array $payloads)
    {
        foreach ($payloads as $payload) {
            $this->enqueue($payload);
        }
    }

    /**
     * Get number of items enqueued so far.
     *
     * @return int
     */
    public function getEnqueuedCount()
    {
        return $this->enqueuedCount;
    }
}
