<?php

namespace boru\process\Queue;

class QueueRunnerConfig
{
    public $queueName          = 'default';
    public $numWorkers         = 1;

    // Worker limits
    public $maxItems           = 0;
    public $idleSleepUs        = 100000;
    public $stopWhenEmpty      = true;
    public $maxIdleSeconds     = 0.0;
    public $maxRunTime         = 0.0;

    public static function fromArray(array $options)
    {
        $cfg = new self();

        if (isset($options['queue_name']))      $cfg->queueName      = $options['queue_name'];
        if (isset($options['num_workers']))     $cfg->numWorkers     = (int)$options['num_workers'];
        if (isset($options['max_items']))       $cfg->maxItems       = (int)$options['max_items'];
        if (isset($options['idle_sleep_us']))   $cfg->idleSleepUs    = (int)$options['idle_sleep_us'];
        if (isset($options['stop_when_empty'])) $cfg->stopWhenEmpty  = (bool)$options['stop_when_empty'];
        if (isset($options['max_idle_seconds']))$cfg->maxIdleSeconds = (float)$options['max_idle_seconds'];
        if (isset($options['max_run_time']))    $cfg->maxRunTime     = (float)$options['max_run_time'];

        if ($cfg->numWorkers < 1) {
            $cfg->numWorkers = 1;
        }

        return $cfg;
    }
}
