<?php

namespace boru\process\Status\Reporter;

/**
 * StatusReporter that writes JSON-encoded status messages to a stream,
 * typically the write-end of a pipe connected to the manager process.
 */
class PipeStatusReporter implements StatusReporterInterface
{
    /**
     * @var resource
     */
    protected $stream;

    /**
     * @param resource $stream Writable stream (e.g. pipe) for status messages.
     */
    public function __construct($stream)
    {
        if (!is_resource($stream)) {
            throw new \InvalidArgumentException('PipeStatusReporter expects a stream resource.');
        }

        $this->stream = $stream;
    }

    /**
     * {@inheritdoc}
     */
    public function report(array $data)
    {
        // Add a timestamp if not present
        if (!isset($data['time'])) {
            $data['time'] = microtime(true);
        }

        $json = json_encode($data);
        if ($json === false) {
            // Fallback: don't break worker on serialization failure
            return;
        }

        // Write a JSON line; ignore write errors for now.
        @fwrite($this->stream, $json . "\n");
        @fflush($this->stream);
    }
}
