<?php

namespace boru\process\Status\Reporter;

/**
 * Abstraction for sending status updates from a worker to a manager.
 *
 * Concrete implementations might:
 * - write JSON lines to STDOUT or a pipe,
 * - send messages over a socket,
 * - or just log to a file (for simple/debug scenarios).
 */
interface StatusReporterInterface
{
    /**
     * Report a status update.
     *
     * @param array $data Arbitrary status payload. Should be JSON-serializable
     *                    if the reporter uses JSON over pipes/sockets.
     *
     * @return void
     */
    public function report(array $data);
}
