<?php

namespace boru\process;

/**
 * Generic contract for a worker process managed by ProcessManager.
 *
 * Implementations may process queue items, run commands, etc.
 */
interface WorkerInterface
{
    /**
     * Run the worker loop until completion.
     *
     * Implementations should:
     * - perform their work (e.g. process queued tasks),
     * - periodically report status to a StatusReporter (if any),
     * - exit cleanly when instructed or when there's nothing left to do.
     *
     * @return int Number of work items processed by this worker.
     */
    public function run();
}
