<?php

namespace boru\process\Queue;

class QueueOrchestrationResult
{
    public $enqueued = 0;
    public $processed = 0;

    public $queuedCount = 0;
    public $processingCount = 0;
    public $doneCount = 0;
    public $errorCount = 0;

    public function toArray()
    {
        return array(
            'enqueued'   => $this->enqueued,
            'processed'  => $this->processed,
            'queued'     => $this->queuedCount,
            'processing' => $this->processingCount,
            'done'       => $this->doneCount,
            'error'      => $this->errorCount,
        );
    }

    public static function fromArray(array $data)
    {
        $instance = new self();
        $instance->enqueued        = isset($data['enqueued']) ? (int)$data['enqueued'] : 0;
        $instance->processed       = isset($data['processed']) ? (int)$data['processed'] : 0;
        $instance->queuedCount     = isset($data['queued']) ? (int)$data['queued'] : 0;
        $instance->processingCount = isset($data['processing']) ? (int)$data['processing'] : 0;
        $instance->doneCount       = isset($data['done']) ? (int)$data['done'] : 0;
        $instance->errorCount      = isset($data['error']) ? (int)$data['error'] : 0;
        return $instance;
    }
}