<?php
namespace boru\process\Queue\Worker;

use boru\queue\Entity\QueueItem;
use boru\process\Status\Reporter\StatusReporterInterface;

class WorkerItemContext
{
    /**
     * @var QueueItem
     */
    protected $item;

    /**
     * @var array
     */
    protected $payload;

    /**
     * @var StatusReporterInterface
     */
    protected $reporter;

    public function __construct(QueueItem $item, array $payload, StatusReporterInterface $reporter)
    {
        $this->item      = $item;
        $this->payload   = $payload;
        $this->reporter  = $reporter;
    }

    public function getItem()
    {
        return $this->item;
    }

    public function getPayload()
    {
        return $this->payload;
    }

    public function log($message, array $extra = array())
    {
        $data = array_merge(array(
            'state'     => 'log',
            'queue'     => $this->item->getQueueName(), // or from storage if needed
            'time'      => microtime(true),
            'item_id'   => $this->item->getId(),
            'task_name' => $this->item->getTaskName(),
            'message'   => (string)$message,
        ), $extra);

        $this->reporter->report($data);
    }

    public function error($message, array $extra = array())
    {
        $data = array_merge(array(
            'state'     => 'error_log',
            'queue'     => $this->item->getQueueName(),
            'time'      => microtime(true),
            'item_id'   => $this->item->getId(),
            'task_name' => $this->item->getTaskName(),
            'message'   => (string)$message,
        ), $extra);

        $this->reporter->report($data);
    }
}
