<?php

namespace boru\process\Status\Sink;

use boru\process\Status\WorkerStatusEvent;

/**
 * Simple sink that prints status events for debugging.
 */
class CliDebugStatusSink implements StatusSinkInterface
{
    public function handle(WorkerStatusEvent $event)
    {
        $parts = array(
            'pid=' . $event->pid,
            'state=' . $event->state,
            'processed=' . $event->processed,
            'queue=' . $event->queue,
        );

        if ($event->itemId !== null) {
            $parts[] = 'item=' . $event->itemId;
        }

        if ($event->taskName !== null) {
            $parts[] = 'task=' . $event->taskName;
        }

        if ($event->error) {
            $parts[] = 'error=' . $event->error['message'];
        }
        if ($event->message !== null) {
            $parts[] = 'message=' . $event->message;
        }

        echo '[manager] ' . implode(' ', $parts) . PHP_EOL;
    }

    public function finish()
    {
        // nothing special for now
    }
}
