<?php
namespace boru\qdrant;

use boru\qdrant\Qdrant;
use boru\output\Output;

class Docker {
    /** @var Qdrant */
    public static $client;

    public static function client($client=null) {
        if($client!==null) {
            self::$client = $client;
        }
        if(self::$client === null) {
            self::$client = Qdrant::instance();
        }
        return self::$client;
    }
    public static function name($name=null) {
        $client = self::client();
        if($name!==null) {
            $client->setConfig("docker.name",$name);
        }
        return $client->getConfig("docker.name");
    }
    public static function image($image=null) {
        $client = self::client();
        if($image!==null) {
            $client->setConfig("docker.image",$image);
        }
        return $client->getConfig("docker.image");
    }
    public static function apiPort($port=null) {
        $client = self::client();
        if($port!==null) {
            $client->setConfig("docker.apiPort",$port);
        }
        return $client->getConfig("docker.apiPort");
    }
    public static function grpcPort($port=null) {
        $client = self::client();
        if($port!==null) {
            $client->setConfig("docker.grpcPort",$port);
        }
        return $client->getConfig("docker.grpcPort");
    }
    public static function dataPath($path=null) {
        $client = self::client();
        if($path!==null) {
            $client->setConfig("docker.dataPath",$path);
        }
        return $client->getConfig("docker.dataPath");
    }

    public static function update() {
        $command = "docker pull ".self::image();
        $output = shell_exec($command);
        return $output;
    }

    /**
     * Check if the container is running
     * @return bool 
     */
    public static function status() {
        $cmd = "docker ps --format '{{.Names}}' | grep \"^".static::name()."$\"";
        exec($cmd,$output,$return);
        if($return == 0) {
            return true;
        }
        return false;
    }

    /**
     * Start the container if it is not already running
     * @return array "success"=>bool,"message"=>string
     */
    public static function start($options=[]) {
        if(self::status()) {
            return static::result(true,"Container is already running");
        }
        $apiPort = isset($options["apiPort"]) ? $options["apiPort"] : static::apiPort();
        $grpcPort = isset($options["grpcPort"]) ? $options["grpcPort"] : static::grpcPort();
        $dataPath = isset($options["dataPath"]) ? $options["dataPath"] : static::dataPath();
        $name = isset($options["name"]) ? $options["name"] : static::name();
        $image = isset($options["image"]) ? $options["image"] : static::image();
        $command = "docker run -dti --rm -p $apiPort:6333 -p $grpcPort:6334 -v $dataPath:/qdrant/storage:z --name=$name $image";
        $output = shell_exec($command);
        if(self::status()) {
            return static::result(true,"Container started");
        }
        return static::result(false,"Failed to start container");
    }

    /**
     * Stop the container if it is running
     * @return array "success"=>bool,"message"=>string
     */
    public static function stop() {
        if(!self::status()) {
            return static::result(true,"Container was not running");
        }
        $command = "docker stop ".static::name();
        $output = shell_exec($command);
        if(!self::status()) {
            return static::result(true,"Container stopped");
        }
        return static::result(false,"Failed to stop container");
    }

    public static function result($success,$message) {
        return [
            "success"=>$success,
            "message"=>$message,
        ];
    }
}