<?php
namespace boru\qdrant\api;

class BaseAPI {

    /**
     * @var \boru\qdrant\Qdrant
     */
    private $client;

    public function __construct($client) {
        $this->client = $client;
    }

    public function request($type,$path="",$parameters=[],$guzzleOptions=[]) {
        return $this->client->request($type,$path,$parameters,$guzzleOptions);
    }

    public static function makeUri($path,$params=[],$allowNull=false) {
        $uri = $path;
        $uriParts = [];
        foreach($params as $key => $value) {
            if($value !== null || $allowNull) {
                $uriParts[] = "$key=$value";
            }
        }
        if(!empty($uriParts)) {
            $uri .= "?".implode("&",$uriParts);
        }
        return $uri;
    }
}