<?php
namespace boru\qdrant\api;

use boru\qdrant\Qdrant;

class PointsAPI extends BaseAPI {
    public function getPoints($collection,$params=[]) {
        return $this->request("post","collections/$collection/points",$params);
    }
    public function get($collection,$id) {
        return $this->request("get","collections/$collection/points/$id");
    }
    public function upsert($collection,$params=[],$wait=null,$ordering=null) {
        $uri = static::makeUri("collections/$collection/points",["wait" => $wait,"ordering" => $ordering]);
        return $this->request("put",$uri,$params);
    }
    public function delete($collection,$params=[],$wait=null,$ordering=null) {
        $uri = static::makeUri("collections/$collection/points/delete",["wait" => $wait,"ordering" => $ordering]);
        return $this->request("post",$uri,$params);
    }
    public function updateVectors($collection,$params=[],$wait=null,$ordering=null) {
        $uri = static::makeUri("collections/$collection/points/vectors",["wait" => $wait,"ordering" => $ordering]);
        return $this->request("patch",$uri,$params);
    }
    public function deleteVectors($collection,$params=[],$wait=null,$ordering=null) {
        $uri = static::makeUri("collections/$collection/points/vectors/delete",["wait" => $wait,"ordering" => $ordering]);
        return $this->request("post",$uri,$params);
    }
    public function setPayload($collection,$params=[],$wait=null,$ordering=null) {
        $uri = static::makeUri("collections/$collection/points/payload",["wait" => $wait,"ordering" => $ordering]);
        return $this->request("post",$uri,$params);
    }
    public function overwritePayload($collection,$params=[],$wait=null,$ordering=null) {
        $uri = static::makeUri("collections/$collection/points/payload",["wait" => $wait,"ordering" => $ordering]);
        return $this->request("put",$uri,$params);
    }
    public function clearPayload($collection,$params=[],$wait=null,$ordering=null) {
        $uri = static::makeUri("collections/$collection/points/payload/clear",["wait" => $wait,"ordering" => $ordering]);
        return $this->request("post",$uri,$params);
    }
    public function batch($collection,$params=[],$wait=null,$ordering=null) {
        $uri = static::makeUri("collections/$collection/points/batch",["wait" => $wait,"ordering" => $ordering]);
        return $this->request("post",$uri,$params);
    }
    public function scroll($collection,$params=[]) {
        return $this->request("post","collections/$collection/points/scroll",$params);
    }
}