<?php
namespace boru\qdrant\api;

use boru\qdrant\Qdrant;

class SearchAPI extends BaseAPI {
    public function search($collectionName,$params=[],$consistency=null,$timeout=null) {
        $uri = static::makeUri("collections/$collectionName/points/search",["consistency" => $consistency,"timeout" => $timeout]);
        return $this->request("post",$uri,$params);
    }
    public function searchBatch($collectionName,$params=[],$consistency=null,$timeout=null) {
        $uri = static::makeUri("collections/$collectionName/points/search/batch",["consistency" => $consistency,"timeout" => $timeout]);
        return $this->request("post",$uri,$params);
    }
    public function searchGroups($collectionName,$params=[],$consistency=null,$timeout=null) {
        $uri = static::makeUri("collections/$collectionName/points/search/groups",["consistency" => $consistency,"timeout" => $timeout]);
        return $this->request("post",$uri,$params);
    }
    public function recommend($collectionName,$params=[],$consistency=null,$timeout=null) {
        $uri = static::makeUri("collections/$collectionName/points/recommend",["consistency" => $consistency,"timeout" => $timeout]);
        return $this->request("post",$uri,$params);
    }
    public function recommendBatch($collectionName,$params=[],$consistency=null,$timeout=null) {
        $uri = static::makeUri("collections/$collectionName/points/recommend/batch",["consistency" => $consistency,"timeout" => $timeout]);
        return $this->request("post",$uri,$params);
    }
    public function recommendGroups($collectionName,$params=[],$consistency=null,$timeout=null) {
        $uri = static::makeUri("collections/$collectionName/points/recommend/groups",["consistency" => $consistency,"timeout" => $timeout]);
        return $this->request("post",$uri,$params);
    }
    public function discover($collectionName,$params=[],$consistency=null,$timeout=null) {
        $uri = static::makeUri("collections/$collectionName/points/discover",["consistency" => $consistency,"timeout" => $timeout]);
        return $this->request("post",$uri,$params);
    }
    public function discoverBatch($collectionName,$params=[],$consistency=null,$timeout=null) {
        $uri = static::makeUri("collections/$collectionName/points/discover/batch",["consistency" => $consistency,"timeout" => $timeout]);
        return $this->request("post",$uri,$params);
    }
    public function query($collectionName,$params=[],$consistency=null,$timeout=null) {
        $uri = static::makeUri("collections/$collectionName/points/query",["consistency" => $consistency,"timeout" => $timeout]);
        return $this->request("post",$uri,$params);
    }
    public function queryBatch($collectionName,$params=[],$consistency=null,$timeout=null) {
        $uri = static::makeUri("collections/$collectionName/points/query/batch",["consistency" => $consistency,"timeout" => $timeout]);
        return $this->request("post",$uri,$params);
    }
    public function queryGroups($collectionName,$params=[],$consistency=null,$timeout=null) {
        $uri = static::makeUri("collections/$collectionName/points/query/groups",["consistency" => $consistency,"timeout" => $timeout]);
        return $this->request("post",$uri,$params);
    }
    public function matrixPairs($collectionName,$params=[],$consistency=null,$timeout=null) {
        $uri = static::makeUri("collections/$collectionName/points/search/matrix/pairs",["consistency" => $consistency,"timeout" => $timeout]);
        return $this->request("post",$uri,$params);
    }
    public function matrixOffsets($collectionName,$params=[],$consistency=null,$timeout=null) {
        $uri = static::makeUri("collections/$collectionName/points/search/matrix/offsets",["consistency" => $consistency,"timeout" => $timeout]);
        return $this->request("post",$uri,$params);
    }
}