<?php
namespace boru\qdrant\models;

use boru\dhutils\traits\JsonTrait;
use boru\qdrant\Qdrant;

class Base implements \JsonSerializable {

    /**
     * @var \boru\qdrant\Qdrant
     */
    private $client;
    public function client($client=null) {
        if($client!==null) {
            self::$client = $client;
        }
        if(self::$client === null) {
            self::$client = Qdrant::instance();
        }
        return self::$client;
    }
    
    use JsonTrait;
    public function toArray() {
        return [];
    }
    public function __toString() {
        return json_encode($this->toArray());
    }
}