<?php
namespace boru\qdrant\models;

use boru\dot\Dot;
use boru\qdrant\api\CollectionsAPI;
use boru\qdrant\api\PointsAPI;
use boru\qdrant\Qdrant;

class Collection extends Base {
    private $name;
    private $options = [
        "on_disk_payload" => null,
        "hnsw_config" => [],
        "wal_config" => [],
        "optimizers_config"=> [],
        "quantization_config" => [],
        "sparse_vectors" => [],
        "vectors" => [],
        "vector" => null,
    ];
    
    public function __construct($name,$options=[]) {
        $this->name = $name;
        foreach($options as $key => $value) {
            $this->set($key,$value);
        }
    }

    public function toArray($forConfig=false) {
        if(!$forConfig) {
            return [
                "name" => $this->name,
                "options" => $this->options
            ];
        }
        $array = $this->options;
        foreach($array as $key => $value) {
            if($value === null || empty($value)) {
                unset($array[$key]);
            } elseif(is_object($value)) {
                $array[$key] = $value->toArray();
            }
        }
        return $array;
    }

    public function name($name=null) {
        if($name !== null) {
            $this->name = $name;
        }
        return $this->name;
    }
    public function options($options=null) {
        if($options !== null) {
            $this->options = $options;
        }
        return $this->options;
    }
    public function set($key,$value) {
        return Dot::set($this->options,$key,$value);
    }
    public function get($key,$default=null) {
        return Dot::get($this->options,$key,$default);
    }

    public function save($client=null) {
        if(empty($this->name)) {
            throw new \Exception("Collection name is required");
        }
        if($client === null) {
            $client = Qdrant::instance();
        }
        $api = new CollectionsAPI($client);
        if($api->exists($this->name)) {
            return $api->update($this->name,$this->toArray(true));
        } else {
            return $api->create($this->name,$this->toArray(true));
        }
    }

    public function addPoint($point,$client=null) {
        if($client === null) {
            $client = Qdrant::instance();
        }
        if(is_array($point)) {
            $point = new Point($point["id"],$point["vector"],$point["payload"]);
        }
        $api = new PointsAPI($client);
        $api->upsert($this->name,$point);
    }
}