<?php
namespace boru\qdrant\models;

use boru\qdrant\api\PointsAPI;
use boru\qdrant\Qdrant;
use boru\qdrant\response\QdrantResponse;

class Point extends Base {
    private $id;
    private $vector;
    private $payload = [];

    public function __construct($id,$vector,$payload=[]) {
        $this->id = $id;
        $this->vector = $vector;
        $this->payload = $payload;
    }

    public function toArray() {
        return [
            "id" => $this->id,
            "vector" => $this->vector,
            "payload" => $this->payload
        ];
    }

    public function id($id=null) {
        if($id !== null) {
            $this->id = $id;
        }
        return $this->id;
    }
    public function vector($vector=null) {
        if($vector !== null) {
            $this->vector = $vector;
        }
        return $this->vector;
    }
    public function payload($payload=null) {
        if($payload !== null) {
            $this->payload = $payload;
        }
        return $this->payload;
    }

    public function upsert($collectionName) {
        $api = new PointsAPI($this->client());
        return $api->upsert($collectionName,["points"=>[$this->toArray()]]);
    }

    public static function fromId($collectionName,$id,$client=null) {
        if($client === null) {
            $client = Qdrant::instance();
        }
        $api = new PointsAPI($client);
        $response = $api->get($collectionName,["ids"=>$id]);
        return static::fromArray($response);
    }

    public static function fromArray($data) {
        if(!isset($data["id"]) || !isset($data["vector"])) {
            throw new \Exception("Invalid Point data");
        }
        if(!isset($data["payload"])) {
            $data["payload"] = [];
        }
        return new Point($data["id"],$data["vector"],$data["payload"]);
    }

    /**
     * 
     * @param array|QdrantResponse $response 
     * @return void 
     */
    public static function fromResponse($response) {
        if($response instanceof QdrantResponse) {
            $array = $response->get("result");
        } else {
            $array = $response;
        }
        if(!is_array($array)) {
            throw new \Exception("Invalid Point data");
        }
        if(isset($array["id"])) {
            return static::fromArray($array);
        }
        $points = [];
        foreach($array as $point) {
            $points[] = static::fromArray($point);
        }
        return $points;
    }
}