<?php
namespace boru\qdrant\response;

use boru\dhutils\traits\GetSetArray;
use boru\dhttp\core\Response;
use boru\dhutils\traits\IteratorTrait;
use boru\dhutils\traits\JsonTrait;

class QdrantResponse implements \JsonSerializable {
    use GetSetArray;
    use JsonTrait;
    /**
     * @var \boru\dhutils\http\Response
     */
    protected $response;

    protected $body = [];

    /**
     * @param \boru\dhutils\http\Response|array $response
     */
    public function __construct($response) {
        $this->setGetSetMainArray("body");
        if(is_array($response)) {
            $this->body = $response;
        } elseif($response instanceof Response) {
            $this->response = $response;
            $this->body = $response->body(true);
        }
        if(isset($this->body["error"])) {
            throw new ApiException($this->body["error"]);
        }
    }

    public function asArray() {
        return $this->body;
    }

    public function __set($field,$val) {
        $this->set($field,$val);
    }

    /**
     * @param Response $response
     */
    public static function fromResponse($resp) {
        if($resp instanceof Response) {
            return new static($resp);
        }
        return false;
    }

    public static function fromArray($array) {
        if(!is_array($array) && !is_object($array)) {
            $array = json_decode($array,true);
            if(!$array) {
                return false;
            }
        }
        return new static($array);
    }

    public function __toString() {
        return json_encode($this);
    }
}