<?php
namespace boru\qdrant\Cli;

use boru\cli\CLIInterface;
use boru\cli\params\Option;
use boru\output\Output;
use boru\qdrant\Docker;

class QdrantCLI extends CLIInterface {
    public static function CLI_def() {
        return [
            "name"=> "Qdrant Helper CLI",
            "description"=> "A command line interface for interacting with Qdrant",
            "params" => [
                Option::create("config|The configuration file to use"),
            ]
        ];
    }
    public function __construct($command) {

    }

    public function def_docker() {
        return [
            "name"=> "Docker",
            "description"=> "Manage the Qdrant Docker container",
        ];
    }

    public function def_docker_start() {
        return [
            "name"=> "Start",
            "description"=> "Start the Qdrant Docker container",
        ];
    }
    public function cmd_docker_start($cmd) {
        $result = Docker::start();
        Output::outLine($result["message"]);
    }

    public function def_docker_stop() {
        return [
            "name"=> "Stop",
            "description"=> "Stop the Qdrant Docker container",
        ];
    }
    public function cmd_docker_stop($cmd) {
        $result = Docker::stop();
        Output::outLine($result["message"]);
    }

    public function def_docker_restart() {
        return [
            "name"=> "Restart",
            "description"=> "Restart the Qdrant Docker container",
        ];
    }
    public function cmd_docker_restart($cmd) {
        $result = Docker::stop();
        if($result["success"]) {
            Output::outLine($result["message"]);
            $result = Docker::start();
            Output::outLine($result["message"]);
        }
    }

    public function def_docker_status() {
        return [
            "name"=> "Status",
            "description"=> "Check the status of the Qdrant Docker container",
        ];
    }
    public function cmd_docker_status($cmd) {
        if(Docker::status()) {
            Output::outLine("Container is running");
        } else {
            Output::outLine("Container is not running");
        }
    }

    public function def_docker_update() {
        return [
            "name"=> "Update",
            "description"=> "Update the Qdrant Docker container",
        ];
    }
    public function cmd_docker_update($cmd) {
        Docker::update();
    }
}