<?php
namespace boru\qdrant\Api;

use boru\qdrant\Qdrant;

class CollectionsAPI extends BaseAPI {
    public function all() {
        return $this->request("get","collections");
    }
    public function create($collectionName,$params=[]) {
        return $this->request("put","collections/$collectionName",$params);
    }
    public function delete($collectionName) {
        return $this->request("delete","collections/$collectionName");
    }
    public function get($collectionName) {
        return $this->request("get","collections/".$collectionName);
    }
    public function update($collectionName,$params=[]) {
        return $this->request("patch","collections/".$collectionName,$params);
    }
    public function exists($collectionName,$bool=true) {
        $response = $this->request("get","collections/".$collectionName."/exists");
        if($bool) {
            return $response->get("result.exists") ? true : false;
        }
        return $response;
    }

    public function createIndex($collectionName,$fieldName,$fieldSchema=[],$wait=null,$ordering=null) {
        $uri = static::makeUri("collections/$collectionName/index",["wait" => $wait,"ordering" => $ordering]);
        $params = [
            "field_name" => $fieldName,
        ];
        if(!empty($fieldSchema)) {
            $params["field_schema"] = $fieldSchema;
        }
        return $this->request("post",$uri,$params);
    }
    public function deleteIndex($collectionName,$fieldName,$wait=null,$ordering=null) {
        $uri = static::makeUri("collections/$collectionName/index/$fieldName",["wait" => $wait,"ordering" => $ordering]);
        return $this->request("delete",$uri);
    }
}