<?php
namespace boru\qdrant\Filter;
/**
 * Fluent builder for a specific clause (must, should, must_not).
 */
class FilterGroup extends Filter
{
    /** @var Filter */
    private $parent;
    /** @var string */
    private $clause;

    /**
     * @param Filter $parent The parent filter object.
     * @param string $clause The clause to which this group belongs (must, should, must_not).
     */
    public function __construct($parent, $clause)
    {
        $this->parent = $parent;
        $this->clause = $clause;
    }

    /**
     * Add a `match` condition.
     * @param string $key
     * @param mixed $value
     * @return $this
     */
    public function match($key, $value)
    {
        $this->parent->add($this->clause, [
            'key'   => $key,
            'match' => ['value' => $value],
        ]);

        return $this;
    }

    /**
     * Add a `range` condition. Pass operators as [ 'gt'=>..., 'gte'=>..., 'lt'=>..., 'lte'=>... ].
     * @param string $key
     * @param array $operators
     * @return $this
     */
    public function range($key, $operators)
    {
        $this->parent->add($this->clause, [
            'key'   => $key,
            'range' => $operators,
        ]);

        return $this;
    }
}