<?php
namespace boru\qdrant\Models\Params;

use boru\qdrant\Models\Base;

class VectorParams extends Base {
    private $size = 1536;
    private $distance = "cosine";
    private $hnsw_config = [];
    private $quantization_config = [];
    private $on_disk = false;
    private $optimizers_config = [];
    private $datatype;

    public function __construct($size=1536,$distance="Cosine",$options=[]) {
        if(is_array($size)) {
            $options = $size;
            $size = isset($options["size"]) ? $options["size"] : 1536;
            if(isset($options["distance"])) {
                $distance = $options["distance"];
            } elseif(isset($options["metric"])) {
                $distance = $options["metric"];
            }
        } else {
            $this->size = $size;
            $this->distance = $distance;
        }
        $this->hnsw_config = isset($options["hnsw_config"]) ? $options["hnsw_config"] : [];
        $this->quantization_config = isset($options["quantization_config"]) ? $options["quantization_config"] : [];
        $this->optimizers_config = isset($options["optimizers_config"]) ? $options["optimizers_config"] : [];
        $this->on_disk = isset($options["on_disk"]) ? $options["on_disk"] : false;
        $this->datatype = isset($options["datatype"]) ? $options["datatype"] : null;
    }

    public function size($size=null) {
        if($size !== null) {
            $this->size = $size;
        }
        return $this->size;
    }
    public function distance($distance=null) {
        if($distance !== null) {
            $this->distance = $distance;
        }
        return $this->distance;
    }
    public function hnsw_config($hnsw_config=null) {
        if($hnsw_config !== null) {
            $this->hnsw_config = $hnsw_config;
        }
        return $this->hnsw_config;
    }
    public function quantization_config($quantization_config=null) {
        if($quantization_config !== null) {
            $this->quantization_config = $quantization_config;
        }
        return $this->quantization_config;
    }
    public function optimizers_config($optimizers_config=null) {
        if($optimizers_config !== null) {
            $this->optimizers_config = $optimizers_config;
        }
        return $this->optimizers_config;
    }
    public function on_disk($on_disk=null) {
        if($on_disk !== null) {
            $this->on_disk = $on_disk;
        }
        return $this->on_disk;
    }
    public function datatype($datatype=null) {
        if($datatype !== null) {
            $this->datatype = $datatype;
        }
        return $this->datatype;
    }

    public function toArray() {
        $result = [
            "size" => (int) $this->size,
            "distance" => $this->distance,   
        ];
        if($this->on_disk) {
            $result["on_disk"] = $this->on_disk;
        }
        if(!empty($this->hnsw_config)) {
            $result["hnsw_config"] = $this->hnsw_config;
        }
        if(!empty($this->quantization_config)) {
            $result["quantization_config"] = $this->quantization_config;
        }
        if(!empty($this->optimizers_config)) {
            $result["optimizers_config"] = $this->optimizers_config;
        }
        if($this->datatype !== null) {
            $result["datatype"] = $this->datatype;
        }
        return $result;
    }

    public static function OpenAI($size=1536,$distance="Cosine",$options=[]) {
        return new VectorParams($size,$distance,$options);
    }
}