<?php
namespace boru\qdrant\Models;

class Points extends Base implements \ArrayAccess, \IteratorAggregate, \Countable {
    private $points = [];

    /** @var Collection */
    private $collection;

    public function __construct($points=[],$collection=null) {
        if($collection !== null) {
            $this->collection($collection);
        }
        if(is_array($points)) {
            foreach($points as $k=>$point) {
                $points[$k] = $this->addCollectionToPoint($point);
            }
        }
        $this->points = $points;
    }

    public function collection($collection=null) {
        if($collection !== null) {
            if(!$collection instanceof Collection) {
                throw new \Exception("Collection must be an instance of Collection");
            }
            $this->collection = $collection;
        }
        return $this->collection;
    }

    public function toArray() {
        return $this->points;
    }
    public function asArray() {
        return $this->points;
    }
    public function asString() {
        return json_encode($this->points);
    }
    public function asObject() {
        return (object)$this->points;
    }

    public function get($key,$default=null) {
        if(isset($this->points[$key])) {
            return $this->addCollectionToPoint($this->points[$key]);
        }
        return $this->addCollectionToPoint($default);
    }
    public function set($key=null,$value) {
        $value = $this->addCollectionToPoint($value);
        if($key) {
            $this->points[$key] = $value;
        } else {
            $this->points[] = $value;
        }
    }
    public function exists($key=null) {
        if(is_null($key)) {
            return !empty($this->points);
        }
        return isset($this->points[$key]);
    }
    public function remove($key) {
        if(isset($this->points[$key])) {
            unset($this->points[$key]);
        }
    }

    /**
     * Ignore intelephense error, php 5.6 :(
     */
    public function offsetExists($offset) {
        return $this->exists($offset);
    }

    /**
     * Ignore intelephense error, php 5.6 :(
     */
    public function offsetGet($offset) {
        return $this->get($offset);
    }

    /**
     * Ignore intelephense error, php 5.6 :(
     */
    public function offsetSet($offset , $value) {
        $this->set($offset,$value);
    }

    /**
     * Ignore intelephense error, php 5.6 :(
     */
    public function offsetUnset($offset) {
        $this->remove($offset);
    }

    public function getIterator() {
        return new \ArrayIterator($this->points);
    }
    public function count() {
        return count($this->points);
    }

    public function __toString() {
        return json_encode($this->points);
    }

    private function addCollectionToPoint($point) {
        if($point instanceof Point && $this->collection !== null) {
            $point->collection($this->collection);
        }
        return $point;
    }
}