<?php
namespace boru\qdrant\Response;

use boru\dhutils\traits\GetSetArray;
use boru\dhttp\core\Response;
use boru\dhutils\traits\IteratorTrait;
use boru\dhutils\traits\JsonTrait;
use boru\dot\Dot;

class QdrantResponse implements \JsonSerializable {
    /** @var \boru\dhutils\http\Response */
    protected $response;

    /** @var array */
    protected $body = [];

    /**
     * @param \boru\dhutils\http\Response|array $response
     */
    public function __construct($response) {
        if(is_array($response)) {
            $this->body = $response;
        } elseif($response instanceof Response) {
            $this->response = $response;
            $this->body = $response->body(true);
        }
        if(isset($this->body["error"])) {
            throw new ApiException($this->body["error"]);
        }
    }
    
    
    public function set($key,$val="") {
        Dot::set($this->body,$key,$val);
        return $this;
    }
    public function get($key=null,$default=null) {
        if($key === null) {
            return $this->body;
        }
        return Dot::get($this->body,$key,$default);
    }
    public function exists($key=null) {
        if($key === null) {
            return !empty($this->body);
        }
        return Dot::get($this->body,$key,null) !== null;
    }
    public function remove($key) {
        if($this->exists($key)) {
            Dot::delete($this->body,$key);
        }
        return $this;
    }

    public function asArray() {
        return $this->body;
    }

    public function __set($field,$val) {
        $this->set($field,$val);
    }

    /**
     * @param Response $response
     */
    public static function fromResponse($resp) {
        if($resp instanceof Response) {
            return new static($resp);
        }
        return false;
    }

    public static function fromArray($array) {
        if(!is_array($array) && !is_object($array)) {
            $array = json_decode($array,true);
            if(!$array) {
                return false;
            }
        }
        return new static($array);
    }

    public function __toString() {
        return json_encode($this);
    }

    public function jsonSerialize() {
        return $this->asArray();
    }
}