<?php
namespace boru\qdrant\Filter;

class Condition implements \JsonSerializable {
    /** @var string */
    private $key;
    /** @var string */
    private $type;
    /** @var mixed */
    private $value;

    public function __construct($key, $type, $value) {
        $this->key = $key;
        $this->type = $type;
        $this->value = $value;
    }

    public function jsonSerialize() {
        return $this->toArray();
    }

    public function toArray() {
        return [
            'key' => $this->key,
            $this->type => $this->value
        ];
    }
    public function key() {
        return $this->key;
    }
    public function type() {
        return $this->type;
    }
    public function value() {
        return $this->value;
    }
    public function __toString() {
        return json_encode($this->toArray());
    }
}