<?php
namespace boru\qdrant\Filter;
/**
 * Fluent builder for a specific clause (must, should, must_not).
 */
class FilterGroup extends Filter
{
    /** @var Filter */
    private $parent;
    /** @var string */
    private $clause;

    private $conditions = [];

    public function addCondition($condition) {
        $this->conditions[] = $condition;
    }

    public function toArray() {
        $result = [];
        foreach($this->conditions as $condition) {
            $result[] = $condition->toArray();
        }
        return [
            $this->clause => $result
        ];
    }

    /**
     * @param Filter $parent The parent filter object.
     * @param string $clause The clause to which this group belongs (must, should, must_not).
     */
    public function __construct($parent, $clause)
    {
        $this->parent = $parent;
        $this->clause = $clause;
    }

    /**
     * Add a `match` condition.
     * @param string $key
     * @param mixed $value
     * @return $this
     */
    public function match($key, $value)
    {
        /*$this->parent->add($this->clause, [
            'key'   => $key,
            'match' => ['value' => $value],
        ]);*/
        $this->addCondition(new Condition($key, 'match', $value));

        return $this;
    }

    /**
     * Add a `range` condition. Pass operators as [ 'gt'=>..., 'gte'=>..., 'lt'=>..., 'lte'=>... ].
     * @param string $key
     * @param array $operators
     * @return $this
     */
    public function range($key, $operators)
    {
        $this->addCondition(new Condition($key, 'range', $operators));
        /*$this->parent->add($this->clause, [
            'key'   => $key,
            'range' => $operators,
        ]);
        */
        return $this;
    }
}