<?php
namespace boru\query\models;

class Columns extends BaseQuery {

    private $rawColumns = [];
    /** @var Column[]|Value[] */
    private $columns = [];
    private $columnAliases = [];


    public function __construct(...$columns) {
        $this->rawColumns($columns);
    }

    public function getColumns() {
        $this->generateColumns();
        return $this->columns;
    }

    public function getColumn($columnNameOrAlias) {
        foreach($this->columns as $column) {
            if($column->name() == $columnNameOrAlias || $column->alias() == $columnNameOrAlias) {
                return $column;
            }
        }
    }

    public function count() {
        return count($this->getColumns());
    }

    public function toSql() {
        $this->generateColumns();
        $sql = "";
        foreach($this->rawColumns as $colIdx=>$colString) {
            if(isset($this->columns[$colIdx])) {
                $column = $this->columns[$colIdx];
            } else {
                $column = new Value($colString,Value::TYPE_FUNCTION);
            }
            $sql .= $column->toSql().", ";
        }
        $sql = rtrim($sql,", ");
        return $sql;
    }
    public function toSqlSelect() {
        $this->generateColumns();
        $sql = "";
        foreach($this->rawColumns as $colIdx=>$colString) {
            if(isset($this->columns[$colIdx])) {
                $column = $this->columns[$colIdx];
            } else {
                $column = new Value($colString,Value::TYPE_FUNCTION);
            }
            $sql .= $column->toSqlSelect().", ";
        }
        $sql = rtrim($sql,", ");
        return $sql;
    }

    public function addColumn($column) {
        /*$alias = null;
        if(is_array($column) && count($column) == 2) {
            $alias = $column[1];
            $column = $column[0];
        }*/
        $this->rawColumns[] = $column;
        //$this->columnAliases[] = $alias;
        return $this;
    }

    /**
     * @param string[]|string|null $columns
     * @return string[]
     */
    public function rawColumns($columns=null) {
        if($columns!==null) {
            if(is_string($columns)) {
                $columns = explode(",",$columns);
            }
            if(is_array($columns)) {
                if(count($columns) == 1 && is_array($columns[0])) {
                    $columns = $columns[0];
                }
                foreach($columns as $c) {
                    $this->addColumn($c);
                }
            }
        }
        return $this->rawColumns;
    }

    private function generateColumns() {
        $reRun = false;
        if(!$this->getQuery()) {
            return;
        }
        if(count($this->rawColumns) == 0 || count($this->rawColumns) == count($this->columns)) {
            return;
        }
        foreach($this->rawColumns as $idx=>$colString) {
            if(!isset($this->columns[$idx])) {
                if($colString == "*") {
                    if($idx != max(array_keys($this->rawColumns))) {
                        throw new \Exception("Invalid column, * must be the last column");
                    }
                    $allTables = $this->getQuery()->getTables()->getAllTables();
                    foreach($allTables as $table) {
                        foreach($table->columns() as $column) {
                            //$this->columns[] = $column;
                            $this->addColumn($column->refName());
                            $reRun = true;
                        }
                    }
                    unset($this->rawColumns[$idx]);
                } elseif(($column = $this->getQuery()->getColumn($colString))) {
                    $this->columns[$idx] = $column;
                }
            }
        }
        if($reRun) {
            $this->generateColumns();
        }
    }
}