<?php
namespace boru\query\models;

use boru\query\models\Table;
use boru\query\models\Column;
use boru\query\models\Value;

class Condition extends BaseQuery {
    
    private $leftSide;
    private $operator;
    private $rightSide;

    /** @var Column */
    private $column;
    /** @var Value */
    private $value;

    private $bothColumns = false;
    private $bothValues = false;

    public function __construct($leftSide,$operator,$rightSide) {
        $this->leftSide($leftSide);
        $this->operator($operator);
        $this->rightSide($rightSide);
    }

    public function column($column=null) {
        if($column !== null) {
            return $this->leftSide($column);
        }
        return $this->column;
    }
    public function value($value=null) {
        if($value !== null) {
            return $this->rightSide($value);
        }
        return $this->value;
    }

    public function leftSide($leftSide=null) {
        if($leftSide !== null) {
            if(!is_object($leftSide) && !is_array($leftSide)) {
                $leftSide = new Value($leftSide,Value::TYPE_COLUMN);
            }
            if(!($leftSide instanceof Column) && !($leftSide instanceof Value)) {
                throw new \Exception("Invalid left side");
            }
            if($leftSide instanceof Column) {
                $this->column = $leftSide;
            } else {
                $this->value = $leftSide;
            }
            $this->leftSide = $leftSide;
            return $this;
        }
        return $this->leftSide;
    }

    public function operator($operator=null) {
        if($operator !== null) {
            if(!is_object($operator) && !is_array($operator)) {
                $operator = new Operator($operator);
            }
            if(!($operator instanceof Operator)) {
                throw new \Exception("Invalid operator");
            }
            $this->operator = $operator;
            return $this;
        }
        return $this->operator;
    }

    public function rightSide($rightSide=null) {
        if($rightSide !== null) {
            if(!is_object($rightSide) && !is_array($rightSide)) {
                $rightSide = new Value($rightSide,Value::TYPE_VALUE);
            }
            if(!($rightSide instanceof Column) && !($rightSide instanceof Value)) {
                throw new \Exception("Invalid right side");
            }
            if($rightSide instanceof Column) {
                if($this->column) {
                    $this->bothColumns = true;
                } else {
                    $this->column = $rightSide;
                }
            } else {
                if($this->value) {
                    $this->bothValues = true;
                } else {
                    $this->value = $rightSide;
                }
            }
            $this->rightSide = $rightSide;
            return $this;
        }
        return $this->rightSide;
    }

    /**
     * This function is used to populate an array with the value of the field for use in a prepared statement.
     * @param array $values Values array to add the value to
     * @return int The number of values added
     */
    public function prepareValues(&$values=[]) {
        if($this->leftSide() instanceof Value) {
            $this->operator()->prepareSql($this->leftSide(),$values,$this->column());
        }
        if($this->rightSide() instanceof Value) {
            $this->operator()->prepareSql($this->rightSide(),$values,$this->column());
        }
    }

    public function toSql(&$values=[]) {
        
        $leftSide = $this->leftSide()->toSql();
        $operator = $this->operator()->toSql();
        $rightSide = $this->rightSide()->toSql();
        if($this->rightSide() instanceof Value) {
            if($values !== false) {
                $rightSide = $this->operator()->prepareSql($this->rightSide(),$values);
            } else {
                $rightSide = $this->operator()->prepareSql($this->rightSide());
            }
        }
        $sql = $leftSide." ".$operator." ".$rightSide;
        return $sql;
    }

    public static function fromString($string) {
        $parts = explode(" ",$string);
        if(count($parts) != 3) {
            throw new \Exception("Invalid condition string");
        }
        return new Condition($parts[0],$parts[1],$parts[2]);
    }
}