<?php
namespace boru\query\models;

use boru\query\models\Table;

class Join extends BaseQuery {
    private $table;
    /** @var Conditions */
    private $on;
    private $joinType = "INNER JOIN";

    public function __construct($table,$on=null,$joinType="INNER JOIN") {
        $this->table($table);
        $this->type($joinType);
        $this->on($on);
    }

    public function toSql() {
        $sql = $this->joinType." ".$this->table->toSqlJoins()." ON ".$this->on->toSql();
        return $sql;
    }

    public function table($table=null) {
        if($table!==null) {
            if(!($table instanceof Table)) {
                $table = new Table($table);
            }
            $this->table = $table;
        }
        return $this->table;
    }
    public function type($type=null) {
        if($type!==null) {
            $this->joinType = $type;
        }
        return $this->joinType;
    }

    public function on($on=null) {
        if($on!==null) {
            if($on instanceof Conditions) {
                $this->on = $on;
            } else {
                $this->on = new Conditions();
                $this->on->conditions($on);
            }
        }
        if($this->on === null) {
            $this->on = new Conditions();
            $this->on->setQuery($this->getQuery());
        }
        return $this->on;
    }
}