<?php
namespace boru\query\models;

use boru\query\models\interfaces\SelectInterface;

class Value extends BaseQuery implements SelectInterface{
    private $value;
    private $type;

    private $operator;

    const TYPE_VALUE = "value";
    const TYPE_COLUMN = "column";
    const TYPE_FUNCTION = "function";
    const TYPE_SUBQUERY = "subquery";

    public function __construct($value,$type=null) {
        if($type===null) {
            $type = self::TYPE_VALUE;
        }
        $this->type($type);
        $this->value($value);
    }

    public function type($type=null) {
        if($type!==null) {
            if(!in_array($type,[self::TYPE_VALUE,self::TYPE_FUNCTION,self::TYPE_SUBQUERY,self::TYPE_COLUMN])) {
                throw new \Exception("Invalid value type, ".$type);
            }
            $this->type = $type;
        }
        return $this->type;
    }
    public function value($value=null) {
        if($value!==null) {
            $this->value = $value;
        }
        return $this->value;
    }


    public function needsPreparing() {
        return $this->type() == self::TYPE_VALUE;
    }

    public function toSqlSelect() {
        if($this->type() == self::TYPE_COLUMN) {
            return "`".$this->value."`";
        }
        return $this->sqlString();
    }

    /**
     * This function is used to generate a placeholder string for a prepared statement.
     * @param array|string|null $input If an array, it will be appended with the placeholder string. If a string, it will be concatenated with the placeholder string.
     * @return string 
     */
    public function toSql($operator=null) {
        $sql = $this->sqlString($operator);
        /*if(is_array($input)) {
            array_push($input, $sql);
            return $input;
        }
        if($input) {
            return $input." ".$sql;
        }*/
        return $sql;
    }

    /**
     * This function is used to populate an array with the value of the field for use in a prepared statement.
     * @param array $values Values array to add the value to
     * @return array The values array with the value added
     */
    public function values($values=null) {
        if($this->type() == self::TYPE_SUBQUERY || $this->type() == self::TYPE_FUNCTION || $this->type() == self::TYPE_COLUMN) {
            return $values;
        }
        if($values === null) {
            $values = [];
        }
        if(is_array($this->value)) {
            foreach($this->value as $val) {
                $values[] = $val;
            }
        } else {
            $values[] = $this->value;
        }
        return $values;
    }


    private function sqlString($operator=null) {
        if($this->type() == self::TYPE_SUBQUERY) {
            return "(".$this->value.")";
        } elseif($this->type() == self::TYPE_FUNCTION) {
            return $this->value;
        } elseif($this->type() == self::TYPE_COLUMN) {
            return "`".$this->value."`";
        }
        if(is_array($this->value)) {
            if($operator == "between") {
                return $this->value[0]." AND ".$this->value[1];
            } else {
                return str_repeat("?,",count($this->value)-1)."?";
            }
        }
        return "?";
    }

    public static function functionValue($function) {
        return new Value($function,Value::TYPE_FUNCTION);
    }
    public static function subqueryValue($subquery) {
        return new Value($subquery,Value::TYPE_SUBQUERY);
    }
    public static function columnValue($column) {
        return new Value($column,Value::TYPE_COLUMN);
    }
    public static function create($value,$type=null) {
        return new Value($value,$type);
    }
}