<?php
namespace boru\query\models;

use boru\query\models\Table;
use boru\query\models\Join;
use boru\query\models\Column;
use boru\query\models\Value;

class Tables extends BaseQuery {
    /** @var Table[] */
    private $tables;

    /** @var Join[] */
    private $joins = [];

    /** @var Table[] */
    private $allTables = [];
    
    public function __construct($tables=[]) {
        $this->tables($tables);
    }

    public function idColumn() {
        foreach($this->tables as $table) {
            if($table->idColumn()) {
                return $table->idColumn();
            }
        }
    }
    public function primaryTable() {
        return isset($this->tables[0]) ? $this->tables[0] : null;
    }

    public function toSql() {
        $sql = "";
        foreach($this->tables as $table) {
            $sql .= $table->toSqlJoins().", ";
        }
        $sql = rtrim($sql,", ");
        foreach($this->joins as $join) {
            $sql .= " ".$join->toSql();
        }
        return $sql;
    }

    public function addTable($table) {
        if($table instanceof Tables) {
            if(!is_array($this->tables)) {
                $this->tables = [];
            }
            $this->tables = array_merge($this->tables,$table->tables());

            if(!is_array($this->joins)) {
                $this->joins = [];
            }
            $this->joins = array_merge($this->joins,$table->joins);
            return $this;
        }
        if(!($table instanceof Table)) {
            $table = new Table($table);
        }
        $this->tables[] = $table;
        return $this;
    }

    public function addJoin($table,$on=null,$type=null) {
        return $this->join($table,$on,$type);
    }

    public function join($table,$on=null,$type=null) {
        if($table instanceof Join) {
            $table->setQuery($this->getQuery());
            $this->joins[] = $table;
            return $this;
        }
        $join = new Join($table);
        $join->setQuery($this->getQuery());
        $this->joins[] = $join;
        $join->on($on);
        if($type) {
            $join->type($type);
        }
        return $this;
    }

    /**
     * @param Table[]|Table|string|null $tables
     * @return Table[]
     */
    public function tables($tables=null) {
        if($tables!==null) {
            if(is_string($tables)) {
                $tables = explode(",",$tables);
            }
            if(is_array($tables)) {
                foreach($tables as $t) {
                    $this->addTable($t);
                }
            } else {   
                $this->addTable($tables);
            }
        }
        return $this->tables;
    }

    public function joins() {
        return $this->joins;
    }

    public function column($column,$valueType=null) {
        $table = null;
        $alias = null;
        if(is_array($column) && count($column) == 2) {
            $original = $column;
            $column = $column[0];
            $alias = $original[1];
        }
        if($column instanceof Column) {
            if(($table = $column->table())) {
                $table = $table->name();
            }
            $column = $column->name();
        } elseif($column instanceof Value) {
            return $column;
        }
        if(is_string($column) && strpos($column,".") !== false) {
            $parts = explode(".",$column);
            $table = $parts[0];
            $column = $parts[1];
        }
        if(($foundColumn = $this->findColumnFromTables($column,$table))) {
            if($alias) {
                $newColumn = clone $foundColumn;
                $newColumn->alias($alias);
                return $newColumn;
            }
            return $foundColumn;
        }
        if($valueType) {
            return new Value($column,$valueType);
        }
        return null;
    }

    public function createProperties() {

    }

    private function findColumnFromTables($columnString,$tableString=null) {
        $tables = $this->getAllTables();
        if($tableString) {
            foreach($tables as $t) {
                if($t->alias() == $tableString || $t->name() == $tableString) {
                    return $t->column($columnString);
                }
            }
        } else {
            foreach($tables as $t) {
                if($t->column($columnString)) {
                    return $t->column($columnString);
                }
            }
        }
        return null;
    }
    public function getAllTables() {
        $tables = [];
        foreach($this->tables as $table) {
            $tables[] = $table;
        }
        foreach($this->joins as $join) {
            $tables[] = $join->table();
        }
        return $tables;
    }
}