<?php
namespace boru\query\models;

use boru\query\dtos\ConditionDTO;
use boru\query\models\Table;
use boru\query\models\Column;
use boru\query\models\Value;
use boru\query\models\Operator;
use boru\query\models\Condition;

class Conditions extends BaseQuery {

    /** @var Condition[] */
    private $conditions = [];
    /** @var string */
    private $glue = "AND";
    /** @var bool */

    public function __construct(...$conditions) {
        if($conditions) {
            $this->conditions($conditions);
        }
    }

    public function conditions($conditions=null) {
        if($conditions !== null) {
            if(!is_array($conditions)) {
                throw new \Exception("Invalid conditions");
            }
            if(count($conditions) == 3 && !is_array($conditions[0]) && !$conditions[0] instanceof Column && !$conditions[0] instanceof Value) {
                $conditions = [$this->makeCondition([$conditions[0],$conditions[1],$conditions[2]])];
            }
            foreach($conditions as $condition) {
                $this->addCondition($condition);
            }
            return $this;
        }
        return $this->conditions;
    }

    public function andCond(...$conditions) {
        return $this->addCondition(new Conditions(...$conditions));
    }
    public function orCond(...$conditions) {
        return $this->addCondition(new Conditions(...$conditions))->glue("OR");
    }

    public function count() {
        return count($this->conditions);
    }

    public function addCondition($condition) {
        if(is_array($condition)) {
            $condition = $this->makeCondition($condition);
        }
        if($condition instanceof ConditionDTO) {
            $condition = $this->makeCondition([$condition->left(),$condition->operator(),$condition->right()]);
        }
        if(!($condition instanceof Condition || $condition instanceof Conditions)) {
            throw new \Exception("Invalid condition");
        }
        $this->conditions[] = $condition;
        return $this;
    }

    public function glue($glue=null) {
        if($glue !== null) {
            $this->glue = $glue;
            return $this;
        }
        return $this->glue;
    }

    private function makeCondition($condition) {
        if($condition instanceof Condition) {
            return $condition;
        }
        if($condition instanceof Conditions) {
            return $condition;
        }
        if(!is_array($condition)) {
            throw new \Exception("Invalid condition");
        }
        if(count($condition) == 2) {
            $left = $condition[0];
            $operator = "=";
            $right = $condition[1];
        } else if(count($condition) == 3) {
            $left = $condition[0];
            $operator = $condition[1];
            $right = $condition[2];
        } else {
            throw new \Exception("Invalid condition");
        }
        if(($column = $this->getQuery()->getColumn($left)) !== null) {
            $left = $column;
        } else {
            $left = new Value($left);
        }
        $operator = $condition[1];
        if(!is_array($right) && ($column = $this->getQuery()->getColumn($right)) !== null) {
            $right = $column;
        } else {
            $right = new Value($right);
        }
        return new Condition($left,$operator,$right);
    }

    public function toSql(&$values=[],$glue=null) {
        if(empty($this->conditions)) {
            return "";
        }
        $sql = $this->innerSql($values,$glue);
        return "(".$sql.")";
    }

    public function innerSql(&$values=[],$glue=null) {
        if(empty($this->conditions)) {
            return "";
        }
        $parts = [];
        foreach($this->conditions as $condition) {
            $parts[] = $condition->toSql($values,$glue);
        }
        if($glue === null) {
            $glue = $this->glue;
        }
        return implode(" ".$glue." ",$parts);
    }

    public function __toString() {
        return $this->toSql();
    }

    public function insertColumns() {
        $columns = [];
        $newValues = [];
        $questions = array_fill(0,count($newValues),"?");
        foreach($this->conditions as $condition) {
            if($condition instanceof Condition) {
                $start = count($newValues);
                if(($column = $condition->column()) !== null) {
                    $condition->prepareValues($newValues);
                    $columns[] = "`".$column->name()."`";
                }
                if(count($newValues) > $start) {
                    for($i=$start;$i<count($newValues);$i++) {
                        $questions[] = "?";
                    }
                } else {
                    if($condition->value() !== null) {
                        $value = $condition->value();
                        if($value instanceof Value) {
                            if($column instanceof Column) {
                                $value->column($column);
                            }
                        }
                        $questions[] = $condition->toInsertValues($newValues);
                    } else {
                        //print_r($condition->column());
                    }
                }
            }
        }
        //$questions = array_fill(0,count($newValues),"?");
        $sqlColumns = implode(",",$columns);
        return ["columns"=>$sqlColumns,"questions"=>implode(",",$questions),"values"=>$newValues];
    }

    public function columnList() {
        $columns = [];
        foreach($this->conditions as $condition) {
            $columns[] = $condition->leftSide()->toSqlSelect();
        }
        return $columns;
    }
}