<?php
namespace boru\query\models;

class OrderBy extends BaseQuery{
    private $index = 0;
    private $columns = [];
    private $directions = [];

    public function __construct($array=[]) {
        $this->columns = [];
        if($array) {
            foreach($array as $column) {
                $this->add($column);
            }
        }
    }

    public function add($column,$direction=null) {
        if(is_array($column) && count($column) == 2 && in_array(strtoupper($column[1]),["ASC","DESC"])) {
            $direction = $column[1];
            $column = $column[0];
            if(!($column instanceof Column)) {
                $column = new Value($column,Value::TYPE_FUNCTION);
            }
            $this->columns[$this->index] = $column;
            $this->directions[$this->index] = $direction;
            $this->index++;
            return $this;
        }
        if(!$direction) {
            $direction = "ASC";
        }
        $this->columns[$this->index] = $column;
        $this->directions[$this->index] = $direction;
        $this->index++;
            return $this;
    }

    public function toSql($prefix="") {
        if($this->index == 0) {
            return "";
        }
        
        $output = $prefix." ";
        $parts = [];
        foreach($this->columns as $index=>$column) {
            if($column instanceof Column || $column instanceof Value) {
                $column = $column->toSql();
            } else {
                if(($column = $this->getQuery()->getColumn($column))) {
                    $column = $column->toSql();
                } else {
                    $column = new Value($column,Value::TYPE_FUNCTION);
                    $column = $column->toSql();
                }
            }
            $sql = $column;
            if(isset($this->directions[$index])) {
                $sql .= " ".$this->directions[$index];
            }
            $parts[] = $sql;
        }
        $output .= implode(", ",$parts);
        return $output;
    }
}