<?php
namespace boru\queue\Task;

use boru\queue\Entity\QueueItem;

class ClosureTask extends AbstractTask
{
    /** @var callable */
    protected $callable;

    public function __construct($task_name, $callable, $logger = null)
    {
        parent::__construct($task_name, $logger);
        $this->callable = $callable;
    }
    /**
     * @param QueueItem $item
     * @param array     $payload
     * @return array
     */
    protected function doExecute(QueueItem $item, array $payload)
    {
        $result = null;
        if(is_callable($this->callable)) {
            $result = call_user_func($this->callable, $item, $payload);
            if(!is_array($result)) {
                $result = ['result' => $result];
            }
            return $this->buildResult('ok', $result);
        }
        return $this->buildResult('error', ['message' => 'Callable not valid']);
    }
}
