<?php
namespace boru\queue\Task;

class TaskRegistry
{
    /** @var TaskInterface[] keyed by name */
    protected $tasks = array();

    public function register(TaskInterface $task)
    {
        $this->tasks[$task->getName()] = $task;
    }

    /**
     * @param string $name
     * @return TaskInterface|null
     */
    public function get($name)
    {
        if (isset($this->tasks[$name])) {
            return $this->tasks[$name];
        }

        return null;
    }
}
