<?php

require __DIR__ . '/../../vendor/autoload.php';

use boru\dhdb\dhDB;
use boru\queue\Queue;
use boru\queue\Task\TaskRegistry;
use boru\queue\Task\ClosureTask;
use boru\queue\Entity\QueueItem;
use boru\queue\Dhprocess\DhOptions;

$db =  new dhDB(['dbtype'=>'mysql',
    "dbhost"=>"localhost",
    "dbport"=>"3306",
    "dbuser"=>"",
    "dbpass"=>"",
    "dbname"=>""
]);

$registry = new TaskRegistry();

// Register tasks
$registry->register(new ClosureTask('demo_task', function(QueueItem $item, array $payload) {
    return ["sent" => $payload['to'], "time" => date('c')];
}));

$queue = (new Queue())
    ->setDb($db)
    ->setTableName('queue_items')
    ->setQueueName('default')
    ->setTaskRegistry($registry)
    ->setDhOptions(
        DhOptions::createDefault(__DIR__ . "/init.php")
            ->setNumWorkers(10)
            ->setMaxQueued(200)
    );
$queue->configureWorker();