<?php

use boru\dhprocess\Task;
use boru\dhprocess\TaskQueue;
use boru\queue\Dhprocess\DhprocessQueueRunner;

require __DIR__.'/init_all.php';

//from init_all.php
global $queueStorage, $taskRegistry;

// 2) Initialize the connector
$dhOptions = array(
    'numWorkers'    => 5,
    'maxQueued'     => 100,
    'extendedBar'   => true,
    'bootstrapFile' => __DIR__ . '/init_worker.php',
    'done'          => true,
);
$runner = new DhprocessQueueRunner($queueStorage, 'default', $dhOptions);

// 2) Register the static worker task with DHProcess
//This is the task registry for the dhprocess TaskQueue, not individual workers
Task::register('queue_executor', array(
    'boru\queue\Dhprocess\QueueDhWorker',
    'execute',
));

$processed = $runner->run();

echo "Processed {$processed} queue item(s)." . PHP_EOL;