<?php
namespace boru\queue\Entity;

class QueueItem
{
    const STATUS_QUEUED     = 0;
    const STATUS_PROCESSING = 1;
    const STATUS_DONE       = 2;
    const STATUS_ERROR      = 3;

    /** @var int|null */
    protected $id;

    /** @var string */
    protected $queueName;

    /** @var string */
    protected $taskName;

    /** @var string|null */
    protected $identifier;

    /** @var string|null JSON payload */
    protected $payload;

    /** @var string|null JSON result */
    protected $result;

    /** @var int */
    protected $status = self::STATUS_QUEUED;

    /** @var \DateTime|null */
    protected $createdAt;

    /** @var \DateTime|null */
    protected $startedAt;

    /** @var \DateTime|null */
    protected $finishedAt;

    /** @var int|null retry count, error code, etc. */
    protected $attempts;

    // Getters / setters…
    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = (int)$id;
    }

    public function getQueueName()
    {
        return $this->queueName;
    }

    public function setQueueName($queueName)
    {
        $this->queueName = $queueName;
    }

    public function getTaskName()
    {
        return $this->taskName;
    }

    public function setTaskName($taskName)
    {
        $this->taskName = $taskName;
    }

    public function getIdentifier()
    {
        return $this->identifier;
    }

    public function setIdentifier($identifier)
    {
        $this->identifier = $identifier;
    }

    public function getPayload()
    {
        return $this->payload;
    }

    public function setPayload($payload)
    {
        $this->payload = $payload;
    }

    public function getResult()
    {
        return $this->result;
    }

    public function setResult($result)
    {
        $this->result = $result;
    }

    public function getStatus()
    {
        return $this->status;
    }

    public function setStatus($status)
    {
        $this->status = (int)$status;
    }

    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    public function setCreatedAt(\DateTime $createdAt = null)
    {
        $this->createdAt = $createdAt;
    }

    public function getStartedAt()
    {
        return $this->startedAt;
    }

    public function setStartedAt(\DateTime $startedAt = null)
    {
        $this->startedAt = $startedAt;
    }

    public function getFinishedAt()
    {
        return $this->finishedAt;
    }

    public function setFinishedAt(\DateTime $finishedAt = null)
    {
        $this->finishedAt = $finishedAt;
    }

    public function getAttempts()
    {
        return $this->attempts;
    }

    public function setAttempts($attempts)
    {
        $this->attempts = (int)$attempts;
    }
}
