<?php
namespace boru\queue\Handler;

use boru\queue\Entity\QueueItem;
use boru\queue\Task\TaskInterface;

class MultiProcessTaskHandler implements TaskHandlerInterface
{
    /** @var SomeMultiThreadingLib */
    protected $engine;

    public function __construct($engine)
    {
        $this->engine = $engine;
    }

    public function handle(TaskInterface $task, QueueItem $item)
    {
        // Example idea: submit to engine, wait for completion, return result
        // Pseudocode:
        // $jobId = $this->engine->submit(function() use ($task, $item) {
        //     return $task->execute($item);
        // });
        // return $this->engine->waitFor($jobId);

        return $task->execute($item);
    }
}
